package com.logicbig.example;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.TokenCountEstimator;

public class MyCustomTokenEstimator implements TokenCountEstimator {
    
    @Override
    public int estimateTokenCountInText(String text) {
        if (text == null) return 0;
        // Approximation: 4 characters per token
        return (int) Math.ceil(text.length() / 4.0);
    }

    @Override
    public int estimateTokenCountInMessage(ChatMessage message) {
        return estimateTokenCountInText(((UserMessage)message).singleText());
    }

    @Override
    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        int total = 0;
        for (ChatMessage message : messages) {
            total += estimateTokenCountInMessage(message);
        }
        return total;
    }
}