package com.logicbig.example;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.ollama.OllamaChatModel;

public class RestaurantReviewAnalyzer {

    public static void main(String[] args) {
        // Create Ollama model with Phi3
        ChatModel model = OllamaChatModel.builder()
                                         .baseUrl("http://localhost:11434")
                                         .modelName("phi3:mini-128k")
                                         .numCtx(4096)
                                         .temperature(0.7)
                                         .build();

        // Define prompt template for review analysis
        String template = "The time is {{current_date_time}}.\n"
                + "Analyze the following restaurant review and provide:\n" +
                "1. Sentiment (positive/negative/neutral)\n" +
                "2. Key points mentioned\n" +
                "3. Suggestions for improvement\n\n" +
                "Review: {{it}}";

        PromptTemplate promptTemplate = PromptTemplate.from(template);

        Prompt prompt = promptTemplate.apply(
                "The food was excellent but "
                        + "the service was very slow. " +
                        "We waited 45 minutes for our main course. " +
                        "The dessert, however, was amazing.");


        // Generate response
        UserMessage userMessage = prompt.toUserMessage();
        ChatResponse response = model.chat(userMessage);

        System.out.println("=== Restaurant Review Analysis ===");
        System.out.println("Prompt:\n" + prompt.text());
        System.out.println("\nAnalysis:\n" + response.aiMessage().text());
    }
}