package com.logicbig.example;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.ollama.OllamaChatModel;
import java.util.Map;

public class ProductRecommendationGenerator {

    public static void main(String[] args) {
        // Create Ollama model
        ChatModel model = OllamaChatModel.builder()
                                         .baseUrl("http://localhost:11434")
                                         .modelName("phi3:mini-128k")
                                         .numCtx(4096)
                                         .temperature(0.7)
                                         .build();

        // Define template with multiple variables
        String template = "Recommend {{number}} {{category}} products " +
                "within a budget of {{budget}}. " +
                "The user prefers: {{preferences}}.";


        Prompt prompt = PromptTemplate.from(template)
                                      .apply(Map.of("number", "3",
                                                    "category", "smartphone",
                                                    "budget", "$500-$700",
                                                    "preferences", "good camera, "
                                                            + "long battery life, and "
                                                            + "5G support"));

        // Generate response
        ChatResponse response = model.chat(prompt.toUserMessage());

        System.out.println("=== Product Recommendations ===");
        System.out.println("Template: " + template);
        System.out.println("\nGenerated Prompt: " + prompt.text());
        System.out.println("\nRecommendations:\n" + response.aiMessage().text());
    }
}