package com.logicbig.example;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;

public class SpringFieldAccessorExample {
    public static void main(String[] args) {
        Person p = new Person();
        Address address = new Address();
        address.setLine1(new AddressLine());
        address.setCity(new City());
        p.setAddress(address);
        System.out.println("before: " + p);
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess(p);
        propertyAccessor.setPropertyValue("address.line1.houseNumber", "4508");
        propertyAccessor.setPropertyValue("address.line1.street", "Westfall Dr");
        propertyAccessor.setPropertyValue("address.city.cityName", "Los Alamos");
        System.out.println("after: " + p);
    }
}