package com.logicbig.example;

import java.lang.reflect.Method;

public class JavaSetterMethodExample {
    public static void main(String[] args) throws Exception {
        Person p = new Person();//must have getters/setters
        Address address = new Address();
        address.setLine1(new AddressLine());
        address.setCity(new City());
        p.setAddress(address); //commenting this will also work
        System.out.println("before: " + p);
        setFieldValue(p, "address.line1.houseNumber", "4508");
        setFieldValue(p, "address.line1.street", "Westfall Dr");
        setFieldValue(p, "address.city.cityName", "Los Alamos");
        System.out.println("after: " + p);
    }

    private static void setFieldValue(Object object, String fieldName, Object fieldValue)
            throws Exception {
        if (fieldName.contains(".")) {
            int firstDotLocation = fieldName.indexOf('.');
            String childFieldName = fieldName.substring(0, firstDotLocation);
            Method getter = object.getClass().getDeclaredMethod(fieldToGetterName(childFieldName));
            Object childFieldInstance = getter.invoke(object);
            if (childFieldInstance == null) {
                Class<?> type = getter.getReturnType();
                //invoking no argument constructor
                childFieldInstance = type.getConstructor().newInstance();
                Method setter = object.getClass().getDeclaredMethod(
                        fieldToSetterName(childFieldName), type);
                setter.invoke(object, childFieldInstance);
            }
            setFieldValue(childFieldInstance, fieldName.substring(firstDotLocation + 1), fieldValue);
        } else {
            Method setter = object.getClass().getDeclaredMethod(fieldToSetterName(fieldName),
                    fieldValue.getClass());
            setter.invoke(object, fieldValue);
        }
    }

    private static String fieldToGetterName(String fieldName) {
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    private static String fieldToSetterName(String fieldName) {
        return "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }
}