package com.logicbig.example;

import java.lang.reflect.Field;

public class JavaFieldExample {
    public static void main(String[] args) throws Exception {
        Person p = new Person();
        Address address = new Address();
        address.setLine1(new AddressLine());
        address.setCity(new City());
        p.setAddress(address); //commenting this will also work
        System.out.println("before: " + p);
        setField(p, "address.line1.houseNumber", "4508");
        setField(p, "address.line1.street", "Westfall Dr");
        setField(p, "address.city.cityName", "Los Alamos");
        System.out.println("after: " + p);
    }

    private static void setField(Object object, String fieldName, Object fieldValue)
            throws Exception {
        if (fieldName.contains(".")) {
            int firstDotLocation = fieldName.indexOf('.');
            String childFieldName = fieldName.substring(0, firstDotLocation);
            Field field = object.getClass().getDeclaredField(childFieldName);
            field.setAccessible(true);
            Object childFieldInstance = field.get(object);
            if (childFieldInstance == null) {
                Class<?> type = field.getType();
                //invoking no argument constructor
                childFieldInstance = type.getConstructor().newInstance();
                field.set(object, childFieldInstance);
            }
            field.setAccessible(false);
            setField(childFieldInstance, fieldName.substring(firstDotLocation + 1), fieldValue);
        } else {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, fieldValue);
            field.setAccessible(false);
        }
    }
}