package com.logicbig.example;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;

public class JavaBeanInfoExample {
    public static void main(String[] args) throws Exception {
        Person p = new Person();//must have getters/setters
        Address address = new Address();
        address.setLine1(new AddressLine());
        address.setCity(new City());
        p.setAddress(address); //commenting this will also work
        System.out.println("before: " + p);
        setFieldValue(p, "address.line1.houseNumber", "4508");
        setFieldValue(p, "address.line1.street", "Westfall Dr");
        setFieldValue(p, "address.city.cityName", "Los Alamos");
        System.out.println("after: " + p);
    }

    private static void setFieldValue(Object object, String fieldName, Object fieldValue)
            throws Exception {
        if (fieldName.contains(".")) {
            int firstDotLocation = fieldName.indexOf('.');
            String childFieldName = fieldName.substring(0, firstDotLocation);
            PropertyDescriptor pd = findPropertyDescriptor(object.getClass(), childFieldName);
            Object childFieldInstance = pd.getReadMethod().invoke(object);

            if (childFieldInstance == null) {
                Class<?> type = pd.getPropertyType();
                childFieldInstance = type.getConstructor().newInstance();
                pd.getWriteMethod().invoke(object, childFieldInstance);
            }
            setFieldValue(childFieldInstance, fieldName.substring(firstDotLocation + 1), fieldValue);
        } else {
            PropertyDescriptor pd = findPropertyDescriptor(object.getClass(), fieldName);
            pd.getWriteMethod().invoke(object, fieldValue);
        }
    }

    private static PropertyDescriptor findPropertyDescriptor(Class<?> c, String fieldName)
            throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(c);
        return Arrays.stream(beanInfo.getPropertyDescriptors())
                     .filter(pd -> pd.getName().equals(fieldName))
                     .findAny()
                     .orElseThrow(() -> new IllegalArgumentException("field not found: " + fieldName));
    }
}