package com.logicbig.example;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Optional;

public class JavaBeanInfoExample {
    public static void main(String[] args) throws Exception {
        Person p = new Person();//must have getters and setters
        System.out.println("before: " + p);
        BeanInfo beanInfo = Introspector.getBeanInfo(Person.class);
        Optional<PropertyDescriptor> propertyDescriptor = Arrays.stream(beanInfo.getPropertyDescriptors())
                                                                .filter(pd -> pd.getName().equals("name"))
                                                                .findAny();
        if (propertyDescriptor.isPresent()) {
            propertyDescriptor.get().getWriteMethod().invoke(p, "Tina");
            System.out.println("after: " + p);
        }
    }
}