package com.logicbig.example;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping("/app")
public class MyController2 {

    @ResponseBody
    @RequestMapping("") //same as @RequestMapping
    public String appRootHandler(HttpServletRequest request) {
        return "response from appRootHandler()";
    }

    @ResponseBody
    @RequestMapping("test")
    public String appTestHandler() {
        return "response from appTestHandler()";
    }

    /* this will conflict with @ResponseBody("")
    @ResponseBody
    @RequestMapping
    public String appFallbackHandler(HttpServletRequest request) {
        return "response from fallbackHandler for uri: "+request.getRequestURI();
    }*/
}