package com.logicbig.example;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.servlet.http.HttpServletRequest;

@Controller
public class MyController {

    @ResponseBody
    @RequestMapping("")
    public String rootHandler(HttpServletRequest request) {
        return "response from rootHandler()";
    }

    @ResponseBody
    @RequestMapping("test")
    public String testHandler() {
        return "response from testHandler()";
    }

    @ResponseBody
    @RequestMapping
    public String fallbackHandler(HttpServletRequest request) {
        return "response from fallbackHandler for uri: "+request.getRequestURI();
    }
}