package com.logicbig.example;

import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Controller
public class MyCustomErrorController extends AbstractErrorController {

    public MyCustomErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @RequestMapping(value = "/error", produces = MediaType.APPLICATION_XML_VALUE)
    @ResponseBody
    public Error handleError(HttpServletRequest request) {
        Map<String, Object> errorAttributes = super.getErrorAttributes(request, true);

        List<Attribute> attributes = new ArrayList<>();
        errorAttributes.forEach((key, value) -> {
            Attribute attribute = new Attribute();
            attribute.setKey(key);
            attribute.setValue(value == null ? "" : value.toString());
            attributes.add(attribute);
        });
        Error error = new Error();
        error.setAttributeList(attributes);
        return error;
    }

    @Override
    public String getErrorPath() {
        return "/error";
    }
}