package com.logicbig.example;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.stereotype.Component;
import javax.persistence.EntityManagerFactory;
import java.util.Optional;

@Component
public class ExampleClient {
    @Autowired
    private ArticleRepository repo;

    public void run() {
        //creating and persisting an Article
        Article article = new Article("test article");
        repo.save(article);

        //load article
        Optional<Article> optArticle = repo.findById(article.getId());
        Article loadedArticle = optArticle.get();
        System.out.println(optArticle.get());

        //have some delay to see a clear diff in modified time
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        //modify article
        loadedArticle.setContent("modified content");
        repo.save(loadedArticle);

        //load again
        System.out.println(repo.findById(loadedArticle.getId()).get());
    }


    public static void main(String[] args) {
        AnnotationConfigApplicationContext context =
                new AnnotationConfigApplicationContext(AppConfig.class);
        ExampleClient exampleClient = context.getBean(ExampleClient.class);
        exampleClient.run();
        EntityManagerFactory emf = context.getBean(EntityManagerFactory.class);
        emf.close();
    }
}