package com.logicbig.example;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

@Entity
public class ScheduledEvent {
    @Id
    @GeneratedValue
    private long id;
    private String eventName;

    @Temporal(TemporalType.DATE)
    private Date date;

    @Temporal(TemporalType.TIME)
    private Date start;

    @Temporal(TemporalType.TIME)
    private Date end;

    @Temporal(TemporalType.TIMESTAMP)
    private Date eventCreated;

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getStart() {
        return start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getEventCreated() {
        return eventCreated;
    }

    public void setEventCreated(Date eventCreated) {
        this.eventCreated = eventCreated;
    }

    public static ScheduledEvent create(String name, LocalDate date, LocalTime start, LocalTime end) {
        ScheduledEvent se = new ScheduledEvent();
        se.setEventName(name);

        //setting date
        Calendar cDate = Calendar.getInstance();
        cDate.clear();
        cDate.set(date.getYear(), date.getMonthValue()-1, date.getDayOfMonth());
        se.setDate(cDate.getTime());

        //setting start
        cDate.clear();
        cDate.set(0, 0, 0, start.getHour(), start.getMinute(), start.getSecond());
        se.setStart(cDate.getTime());

        //setting end
        cDate.clear();
        cDate.set(0, 0, 0, end.getHour(), end.getMinute(), end.getSecond());
        se.setEnd(cDate.getTime());

        //setting event create date
        se.setEventCreated(new Date());

        return se;
    }

    @Override
    public String toString() {
        return "ScheduledEvent{" +
                "id=" + id +
                ", eventName='" + eventName + '\'' +
                ", date=" + date +
                ", start=" + start +
                ", end=" + end +
                ", eventCreated=" + eventCreated +
                '}';
    }
}