package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEvent();
            findEvent();
            nativeQuery("select CONCAT('start= ', e.start, '\nend= ', e.end, '\ndate= ', e.date,"
                     +"'\neventCreated= ', e.eventCreated)"
                    + " from ScheduledEvent e");
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void persistEvent() {
        ScheduledEvent scheduledEvent = ScheduledEvent.create("Test event",
                LocalDate.of(2018, 6, 1),
                LocalTime.of(9, 30, 45),
                LocalTime.of(11, 45, 30));
        System.out.println("-- persisting entity --");
        System.out.println(scheduledEvent);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(scheduledEvent);
        em.getTransaction().commit();
        em.close();
    }

    private static void findEvent() {
        System.out.println("-- finding entity --");
        EntityManager em = entityManagerFactory.createEntityManager();
        ScheduledEvent scheduledEvent = em.find(ScheduledEvent.class, 1L);
        System.out.println(scheduledEvent);
        em.close();
    }

    public static void nativeQuery(String s) {
        EntityManager em = entityManagerFactory.createEntityManager();
        System.out.println("-- native query --");
        Query query = em.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
        em.close();
    }
}