package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.text.SimpleDateFormat;
import java.util.List;

public class ExampleMain2 {

    public static void main(String[] args) throws Exception {
        EntityManagerFactory emf =
                Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntity(emf);
            runNativeQueries(emf);
            loadEntity(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntity(EntityManagerFactory emf) throws Exception {
        System.out.println("-- Persisting entities --");
        EntityManager em = emf.createEntityManager();

        Employee e1 = new Employee();
        e1.setName("employee name 1");

        Task task1 = new Task();
        task1.setName("task 1");
        task1.setDescription("task 1 desc");

        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yy");
        Task task2 = new Task();
        task2.setName("task 2");
        task2.setDescription("task 2 desc");

        e1.addTask(sdf.parse("15-01-17"), task1);
        e1.addTask(sdf.parse("20-01-17"), task2);
        System.out.println(e1);

        Employee e2 = new Employee();
        e2.setName("employee name 2");

        Task task3 = new Task();
        task3.setName("task 3");
        task3.setDescription("task 3 desc");

        e2.addTask(sdf.parse("02-05-2017"), task3);
        System.out.println(e2);

        em.getTransaction().begin();
        em.persist(task1);
        em.persist(task2);
        em.persist(task3);
        em.persist(e1);
        em.persist(e2);
        em.getTransaction().commit();
        em.close();
    }

    private static void runNativeQueries(EntityManagerFactory emf) {
        System.out.println("-- Native queries --");
        EntityManager em = emf.createEntityManager();
        ExampleMain.nativeQuery(em, "Select * from Employee");
        ExampleMain.nativeQuery(em, "Select * from Task");
        ExampleMain.nativeQuery(em, "Select * from Employee_TaskMap");
    }

    private static void loadEntity(EntityManagerFactory emf) {
        System.out.println("-- Loading entities --");
        EntityManager em = emf.createEntityManager();
        List<Employee> entityAList = em.createQuery("Select t from Employee t")
                                       .getResultList();
        entityAList.forEach(System.out::println);
        em.close();
    }
}