package com.logicbig.example;

import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Entity
public class Employee {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @ElementCollection
    private Map<Task, Date> taskMap;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Task, Date> getTaskMap() {
        return taskMap;
    }

    public void setTaskMap(Map<Task, Date> tasks) {
        this.taskMap = tasks;
    }

    public void addTask(Date taskDate, Task task) {
        if (taskMap == null) {
            taskMap = new HashMap<>();
        }
        taskMap.put(task, taskDate);
    }

    @Override
    public String toString() {
        return "Employee{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", taskMap=" + taskMap +
                '}';
    }
}